// Wait for the DOM to be fully loaded
document.addEventListener('DOMContentLoaded', function() {
    // Mobile menu toggle
    const hamburger = document.querySelector('.hamburger');
    const navLinks = document.querySelector('.nav-links');
    const navLinksItems = document.querySelectorAll('.nav-links li a');
    
    if (hamburger) {
        hamburger.addEventListener('click', function() {
            this.classList.toggle('active');
            navLinks.classList.toggle('active');
            document.body.style.overflow = this.classList.contains('active') ? 'hidden' : '';
        });
    }
    
    // Close mobile menu when clicking on a nav link
    navLinksItems.forEach(link => {
        link.addEventListener('click', function() {
            if (hamburger.classList.contains('active')) {
                hamburger.classList.remove('active');
                navLinks.classList.remove('active');
                document.body.style.overflow = '';
            }
        });
    });
    
    // Sticky header on scroll
    const header = document.querySelector('.header');
    let lastScroll = 0;
    
    window.addEventListener('scroll', function() {
        const currentScroll = window.pageYOffset;
        
        // Add/remove scrolled class based on scroll position
        if (currentScroll > 100) {
            header.classList.add('scrolled');
        } else {
            header.classList.remove('scrolled');
        }
        
        // Hide/show header on scroll direction
        if (currentScroll <= 0) {
            header.classList.remove('scroll-up');
            return;
        }
        
        if (currentScroll > lastScroll && !header.classList.contains('scroll-down')) {
            // Scroll down
            header.classList.remove('scroll-up');
            header.classList.add('scroll-down');
        } else if (currentScroll < lastScroll && header.classList.contains('scroll-down')) {
            // Scroll up
            header.classList.remove('scroll-down');
            header.classList.add('scroll-up');
        }
        
        lastScroll = currentScroll;
    });
    
    // Back to top button
    const backToTopBtn = document.querySelector('.back-to-top');
    
    if (backToTopBtn) {
        window.addEventListener('scroll', function() {
            if (window.pageYOffset > 300) {
                backToTopBtn.classList.add('active');
            } else {
                backToTopBtn.classList.remove('active');
            }
        });
        
        backToTopBtn.addEventListener('click', function(e) {
            e.preventDefault();
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    }
    
    // Smooth scrolling for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function(e) {
            e.preventDefault();
            
            const targetId = this.getAttribute('href');
            if (targetId === '#') return;
            
            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                window.scrollTo({
                    top: targetElement.offsetTop - 80,
                    behavior: 'smooth'
                });
            }
        });
    });
    
    // Telegram Bot Integration
    const TELEGRAM_BOT_TOKEN = '8458605801:AAF05ej10liaDMSg8R80p_qrl5QDiFyKbe0';
    const TELEGRAM_CHAT_ID = '1134677664'; // عبدالله's Chat ID

    // Function to send message to Telegram
    async function sendToTelegram(formData) {
        const { name, phone, message } = formData;
        
        const text = `📨 *رسالة جديدة من نوصلك*\n\n` +
                    `👤 *الاسم:* ${name}\n` +
                    `📱 *رقم الهاتف:* ${phone || 'غير محدد'}\n\n` +
                    `💬 *الرسالة:*\n${message}`;

        try {
            const response = await fetch(`https://api.telegram.org/bot${TELEGRAM_BOT_TOKEN}/sendMessage`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    chat_id: TELEGRAM_CHAT_ID,
                    text: text,
                    parse_mode: 'Markdown',
                    disable_web_page_preview: true,
                }),
            });

            const data = await response.json();
            return data.ok;
        } catch (error) {
            console.error('Error sending message to Telegram:', error);
            return false;
        }
    }

    // Form submission
    const contactForm = document.getElementById('contactForm');
    
    if (contactForm) {
        contactForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            // Show loading state
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalBtnText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> جاري الإرسال...';
            
            try {
                // Get form data
                const formData = new FormData(this);
                const formObject = {};
                formData.forEach((value, key) => {
                    formObject[key] = value.trim();
                });
                
                // Basic validation
                if (!formObject.name || !formObject.message) {
                    throw new Error('الرجاء إدخال الاسم والرسالة');
                }
                
                // Send to Telegram
                const success = await sendToTelegram(formObject);
                
                if (success) {
                    // Show success message
                    alert('تم إرسال رسالتك بنجاح! سنتواصل معك قريباً.');
                    // Reset form
                    this.reset();
                } else {
                    throw new Error('حدث خطأ أثناء إرسال الرسالة. يرجى المحاولة مرة أخرى.');
                }
            } catch (error) {
                console.error('Form submission error:', error);
                alert(error.message || 'حدث خطأ غير متوقع. يرجى المحاولة مرة أخرى.');
            } finally {
                // Reset button state
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalBtnText;
            }
        });
    }
    
    // Initialize AOS and show more functionality
    AOS.init({
        duration: 800,
        easing: 'ease-in-out',
        once: true,
        mirror: false
    });

    // Show more functionality for services
    const showMoreBtn = document.getElementById('showMoreBtn');
    const servicesGrid = document.querySelector('.services-grid');
    
    if (showMoreBtn && servicesGrid) {
        showMoreBtn.addEventListener('click', function() {
            servicesGrid.classList.toggle('show-all');
            
            if (servicesGrid.classList.contains('show-all')) {
                this.innerHTML = '<i class="fas fa-chevron-up"></i> عرض أقل';
                this.classList.add('active');
            } else {
                this.innerHTML = '<i class="fas fa-chevron-down"></i> عرض المزيد';
                this.classList.remove('active');
                // Scroll to services section when showing less
                document.getElementById('services').scrollIntoView({ behavior: 'smooth' });
            }
        });
    }
    
    // Add animation classes on scroll
    const animateOnScroll = function() {
        const elements = document.querySelectorAll('.animate-on-scroll');
        
        elements.forEach(element => {
            const elementPosition = element.getBoundingClientRect().top;
            const screenPosition = window.innerHeight / 1.3;
            
            if (elementPosition < screenPosition) {
                element.classList.add('animate');
            }
        });
    };
    
    window.addEventListener('scroll', animateOnScroll);
    // Initial check in case elements are already in viewport
    animateOnScroll();
    
    // Add loading animation
    window.addEventListener('load', function() {
        document.body.classList.add('loaded');
    });
    
    // Statistics Counter Animation with AOS
    function initCounterAnimation() {
        const statNumbers = document.querySelectorAll('.stat-number');
        let animationStarted = false;

        function animateCounter(stat) {
            const target = parseInt(stat.getAttribute('data-count'));
            const duration = 2000; // 2 seconds
            const frameDuration = 16; // ~60fps
            const totalFrames = Math.round(duration / frameDuration);
            let frame = 0;
            
            // Clear any existing content
            stat.textContent = '0';
            
            const counter = setInterval(() => {
                frame++;
                
                // Ease out function for smooth deceleration
                const progress = Math.min(frame / totalFrames, 1);
                const easeOutProgress = 1 - Math.pow(1 - progress, 3); // Cubic ease out
                const current = Math.round(target * easeOutProgress);
                
                // Update the display
                if (frame >= totalFrames) {
                    clearInterval(counter);
                    // Format the final number based on the data-count
                    if (stat.getAttribute('data-count') === '1000' || stat.getAttribute('data-count') === '5000') {
                        stat.textContent = target.toLocaleString('ar-EG') + '+';
                    } else if (stat.getAttribute('data-count') === '24') {
                        stat.textContent = target + '/7';
                    } else {
                        stat.textContent = target.toLocaleString('ar-EG');
                    }
                } else {
                    stat.textContent = current.toLocaleString('ar-EG');
                }
            }, frameDuration);
        }

        function startCounters() {
            if (animationStarted) return;
            animationStarted = true;
            
            statNumbers.forEach(stat => {
                animateCounter(stat);
            });
        }

        // Initialize AOS for the stats section
        AOS.init({
            once: true,
            duration: 1000,
            easing: 'ease-in-out',
            offset: 100,
            disable: function() {
                return window.innerWidth < 768;
            }
        });

        // Listen for AOS animation start
        document.addEventListener('aos:in:about-stats', function() {
            startCounters();
        });

        // Fallback in case AOS doesn't trigger
        const statsSection = document.querySelector('.about-stats');
        if (statsSection) {
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        startCounters();
                        observer.unobserve(entry.target);
                    }
                });
            }, {
                threshold: 0.5
            });

            observer.observe(statsSection);
        }
    }

    // Initialize FAQ functionality
    function initFAQ() {
        const faqItems = document.querySelectorAll('.faq-item');
        
        faqItems.forEach(item => {
            const question = item.querySelector('.faq-question');
            
            question.addEventListener('click', () => {
                // Close all other FAQ items
                faqItems.forEach(otherItem => {
                    if (otherItem !== item) {
                        otherItem.classList.remove('active');
                    }
                });
                
                // Toggle current item
                item.classList.toggle('active');
                
                // Add smooth scrolling for better UX
                if (item.classList.contains('active')) {
                    setTimeout(() => {
                        item.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 300);
                }
            });
            
            // Add keyboard accessibility
            question.setAttribute('tabindex', '0');
            question.addEventListener('keydown', (e) => {
                if (e.key === 'Enter' || e.key === ' ') {
                    e.preventDefault();
                    item.classList.toggle('active');
                }
            });
        });
        
        // Open first FAQ by default
        if (faqItems.length > 0) {
            faqItems[0].classList.add('active');
        }
    }
    
    // Initialize all components when DOM is fully loaded
    function initAll() {
        initCounterAnimation();
        initFAQ();
    }
    
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initAll);
    } else {
        initAll();
    }
});
